function [Torque] = meshingTorque(pt, r2contact1, r2contact2, Rext, w)
%UNTITLED2 Summary of this function goes here
% pt [Pa]: vettore RIGA che contiene la pressione in V trapped
% r2contact1, r2contact2 [mm] : raggi di connessione punti di contatto 1,2
%                               con centro ruota 2
% Rext [mm] : raggio esterno ruote
% w  [mm] : spessore

global pm
global pa

w = w*0.001; %conversione [mm] ---> [m]
Rext = Rext*0.001;              %conversione [mm] ---> [m]
r2contact1 = r2contact1*0.001;  %conversione [mm] ---> [m]
r2contact2 = r2contact2*0.001;  %conversione [mm] ---> [m]

% Calcolo Torque di pressione (ruota 2)
    if isnan(pt) == 1
        Torque = (pm - pa)*w*(Rext^2 - r2contact1^2)/2;
    else
        Torque =  (pm - pt)*w*(Rext^2 - r2contact1^2)/2 + ...
                      (pt - pa)*w*(Rext^2 - r2contact2^2)/2;
    end
end

